if unsupported then return end

local function hud_render()
    -- ensure round state is set to round active or end
    if eHudVariables.leaderboard == false then return end
    if gGlobalSyncTable.roundState == ROUND_STATE_INACTIVE then return end
    if unsupported then return end

    -- set font and res
    djui_hud_set_font(FONT_NORMAL)
    djui_hud_set_resolution(RESOLUTION_DJUI)

    -- get screen height
    local screenHeight = djui_hud_get_screen_height()

    -- get width of rect
    local width = 400

    -- get initial height for rect
    -- this includes survivor text
    local height = 60

    survivors = {}

    -- loop thru all survivors
    for i = 0, MAX_PLAYERS - 1 do
        local np = gNetworkPlayers[i]
        local s = gPlayerSyncTable[i]
        local m = gMarioStates[i]

        if np.connected and m.health > 0xFF and (s.finished
        or gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE) then
            -- add survivor to table
            table.insert(survivors, i)
        end
    end

    if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
        -- sort survivers via time if the player's finished
        -- otherwise use the distance to the flag
        table.sort(survivors, function (a, b)
            if gPlayerSyncTable[a].finished
            or gPlayerSyncTable[b].finished then
                return gPlayerSyncTable[a].time < gPlayerSyncTable[b].time
            else
                local aO = gMarioStates[a].marioObj
                local bO = gMarioStates[b].marioObj

                local pos = gLevels[gGlobalSyncTable.level].flagPos

                return dist_between_object_and_point(aO, pos.x, pos.y, pos.z) < dist_between_object_and_point(bO, pos.x, pos.y, pos.z)
            end
        end)
    else
        -- sort survivers via time
        table.sort(survivors, function (a, b)
            return gPlayerSyncTable[a].time < gPlayerSyncTable[b].time
        end)
    end

    if #survivors < 1 then
        -- if there are no survivors, increase height by 25
        height = height + 25
    else
        -- give each survivor 35 pixels of play room plus 25 for padding at bottom
        height = height + (#survivors - 1) * 35 + 25
    end

    -- get x and y for rect, as well as the selected theme
    local theme = get_selected_theme()
    local x = 20
    local y = screenHeight / 2 - height / 2

    -- render rect
    djui_hud_set_color(theme.leaderboard.r, theme.leaderboard.g, theme.leaderboard.b, theme.leaderboard.a)

    if eHudVariables.outlines then
        djui_hud_render_rect_rounded_outlined(x, y, width, height, theme.leaderboardOutline.r, theme.leaderboardOutline.g, theme.leaderboardOutline.b, 4)
    else
        djui_hud_render_rect_rounded(x, y, width, height, 30)
    end

    -- set x and y to have more padding
    x = 5
    y = y + 5

    -- render survivors text
    djui_hud_set_adjusted_color(theme.text.r, theme.text.g, theme.text.b, 255)
    djui_hud_print_text("Survivors", 175, y, 1)

    local position = 1

    if #survivors > 0 then
        -- render players text
        for s = 1, #survivors do -- survivors is a table that starts at 1

            local i = survivors[s]
            -- offset y
            y = y + 35
            -- reset x
            x = 25
            -- render player position
            local positionText = "#" .. position
            local positionColorR, positionColorG, positionColorB = hex_to_rgb(get_placement_color(position))

            djui_hud_set_color(positionColorR, positionColorG, positionColorB, 255)
            djui_hud_print_text(positionText, x, y, 1)
            -- get player color
            local r, g, b = hex_to_rgb(network_get_player_text_color_string(i))
            djui_hud_set_color(r, g, b, 255)
            -- get player name
            local name = string_without_hex(gNetworkPlayers[i].name)
            -- offset x
            x = djui_hud_measure_text(positionText) + 30
            xTime = djui_hud_measure_text(positionText .. name) + 80
            -- render text
            if gGlobalSyncTable.roundState ~= ROUND_STATE_END then
                djui_hud_print_text(name, x + 40, y, 1)
                render_player_head(i, x, y, 1.9, 1.9)
            else
                djui_hud_print_text(name, x + 40, y, 1)
                render_player_head(i, x, y, 1.9, 1.9)
                djui_hud_set_color(positionColorR, positionColorG, positionColorB, 255)
                djui_hud_print_text(string.format("%.3f", gPlayerSyncTable[i].time / 30) .. "s", xTime, y, 1)
            end
            -- get dist between mario and flag
            -- if the round state is set to round active
            if gGlobalSyncTable.roundState == ROUND_STATE_ACTIVE then
                local pos = gLevels[gGlobalSyncTable.level].flagPos
                -- get dist between objects
                local dist = math.floor(dist_between_object_and_point(gMarioStates[i].marioObj, pos.x, pos.y, pos.z) / 100)
                -- get distance text
                local distText = tostring(dist)
                -- if we finished, set dist text to finished
                if gPlayerSyncTable[i].finished then
                    distText = "finished."
                end
                -- offset x
                x = djui_hud_measure_text(positionText .. name) + 85
                -- set color
                djui_hud_set_color(positionColorR, positionColorG, positionColorB, 255)
                -- render text
                djui_hud_print_text(distText, x, y, 1)
            end

            -- increase position
            position = position + 1
        end
    end

    -- if we didn't render a player...
    if position == 1 then
        -- ...offset y...
        y = y + 35
        -- ...and render text
        djui_hud_set_color(255, 0, 0, 255)
        djui_hud_print_text("None", 200, y, 1)
    end
end

hook_event(HOOK_ON_HUD_RENDER, hud_render)